#!/bin/sh

## Function
isEmptyFolder () {
	local nCheckFolder=$1
	local nDefIFS=$IFS
	IFS='
'
	local nIsEmpty=1
	local nFilePaths=`/bin/ls "${nCheckFolder}"`
	
	for nFileName in ${nFilePaths}
	do
		local nName=`/bin/echo "${nFileName}" | /usr/bin/awk -F. '{print $1}'`
		if [ -n "${nName}" ]
		then
			nIsEmpty=0
			break
		fi
	done
	IFS=$nDefIFS
	
	echo ${nIsEmpty}
}

deleteOptionsXML ()
{
	local nEpsonNetFolder=$1
	local nOptionsXML="${nEpsonNetFolder}/Options.xml"
	local nOptionSettingsXML="${nEpsonNetFolder}/OptionSettings.xml"
	
	if [ -d "${nEpsonNetFolder}" ]
	then
		if [ -f "${nOptionsXML}" ]
		then
			/bin/rm -Rf "${nOptionsXML}"
		fi
		
		if [ -f "${nOptionSettingsXML}" ]
		then
			/bin/rm -Rf "${nOptionSettingsXML}"
		fi
		
		local nIsEmptyFolder=`isEmptyFolder "${nEpsonNetFolder}"`
		if [ ${nIsEmptyFolder} -eq 1 ]
		then
			/bin/rm -Rf "${nEpsonNetFolder}"
		fi
	fi
}

deleteMyDeviceInfo ()
{
	local nEpsonNetFolder=$1
	local nDeviceCachesXML="${nEpsonNetFolder}/DeviceCaches.xml"
	local nMyDevicesXML="${nEpsonNetFolder}/MyDevices.xml"
	
	if [ -d "${nEpsonNetFolder}" ]
	then
		if [ -f "${nDeviceCachesXML}" ]
		then
			/bin/rm -Rf "${nDeviceCachesXML}"
		fi
		
		if [ -f "${nMyDevicesXML}" ]
		then
			/bin/rm -Rf "${nMyDevicesXML}"
		fi
		
		local nIsEmptyFolder=`isEmptyFolder "${nEpsonNetFolder}"`
		if [ ${nIsEmptyFolder} -eq 1 ]
		then
			/bin/rm -Rf "${nEpsonNetFolder}"
		fi
	fi
}

#######################################

## Main

# Remove Old Installation Folder
nOldEpsonNetFolder="/Applications/EpsonNet"
nOldEpsonNetConfigV4Folder="${nOldEpsonNetFolder}/EpsonNet Config V4"

if [ -d "${nOldEpsonNetFolder}" ]
then
	if [ -d "${nOldEpsonNetConfigV4Folder}" ]
	then
		/bin/rm -Rf "${nOldEpsonNetConfigV4Folder}"
	fi
	
	nIsEmptyFolder=`isEmptyFolder "${nOldEpsonNetFolder}"`
	if [ ${nIsEmptyFolder} -eq 1 ]
	then
		/bin/rm -Rf "${nOldEpsonNetFolder}"
	fi
fi


# Delete Option File
nCheckFolder="/Users"
nDefIFS=$IFS
IFS='
'
nUserFolders=`/usr/bin/find "${nCheckFolder}" -maxdepth 1`
for nPath in ${nUserFolders}
do
	if [ "${nPath}" == "${nCheckFolder}" -o "${nPath}" == "/Users/Shared" ]
	then
		continue
	fi
	
	nFileName=`/bin/echo "${nPath}" | /usr/bin/awk -F/ '{print $NF}'`
	nName=`/bin/echo "${nFileName}" | /usr/bin/awk -F. '{print $1}'`
	if [ -n "${nName}" ]
	then
		deleteOptionsXML "${nPath}/Library/Preferences/EpsonNet Config V4"
		deleteMyDeviceInfo "${nPath}/Library/Preferences/EpsonNet Config V4"
	fi
done
IFS=$nDefIFS

deleteOptionsXML "/var/root/Library/Preferences/EpsonNet Config V4"
deleteMyDeviceInfo "/var/root/Library/Preferences/EpsonNet Config V4"


exit 0
